import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'banner',
        'admin',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              { functions: { fields: ['title'] } },
              'email'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          folders: {
            fields: [
              'title',
              'uuid',
              {
                documents: {
                  fields: [
                    'slug',
                    'admin',
                    'uuid',
                    'file',
                    'title',
                    'content',
                    'content_type'
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc'
                  }
                }
              }
            ]
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'introduction',
                    'published_at',
                    'image',
                    'content_type',
                    { news_categories: ['uuid', 'title', 'color'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          jobs_grouping_pages: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacesPagesPage = async ({ $route }) => {
  try {
    const { data: spaces } = await http.get('content/spaces', {
      fields: ['uuid', 'title'],
      filters: { 'slug:eq': $route.params.slug }
    })

    const { data } = await http.get('content/spaces_pages', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'image',
        'description'
      ],
      filters: { 'slug:eq': $route.params.pages }
    })

    return { ...data[0], spaces: spaces[0] }
  } catch (err) {
    throw new Error(err)
  }
}
