import { http } from '@inside-library/helpers/Http'

export const fetchServicesDuties = async ({ $route }) => {
  try {
    const { data } = await http.get('content/duties_services', {
      fields: [
        'uuid',
        'title',
        'slug',
        'body',
        'admin',
        'content_type',
        'image',
        'published_at',
        {
          duties: ['title', 'weight', { duty_user: ['lastname', 'firstname'] }]
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}
