export default {
  // duties
  duties: {
    modalFields: [
      'uuid',
      'admin',
      'title',
      'time',
      'date',
      'end_date',
      'weight',
      {
        duty_user: ['uuid', 'firstname', 'lastname']
      },
      {
        duties_services: ['uuid', 'title']
      }
    ]
  },
  // GED
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  // Groups
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  },
  // HR space
  jobs: {
    extendedUrl: ['uuid'],
    modalFields: [
      'title',
      'date',
      'content',
      'email',
      'uuid',
      'content_type',
      { jobs_contracts: ['title'] }
    ]
  },
  rcp_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  // Users
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'email',
      'phone',
      'location',
      'image',
      'fax',
      { subservices: ['title'] },
      { functions: ['title'] },
      { services: ['title'] },
      {
        secretary: [
          'uuid',
          'lastname',
          'firstname',
          'uuid',
          'phone',
          { functions: ['title'] }
        ]
      }
    ]
  }
}
