<?php

namespace Inside\ICHB\Providers;

use Inside\ICHB\Services\Duty;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    public array $singletons = [
        Duty::class => Duty::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/security.php', 'security');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
