<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;

class RenamePhoneFieldForIchb extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'phone',
            options: [
                'name' => 'phone',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'editable' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Téléphone',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 5,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            weight: 5
        );
    }
}
