<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class IchbAddFaq extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        ContentBlueprints::generateContent(contentType: 'faq_categories');
        ContentBlueprints::generateContent(contentType: 'faq_questions');
        $this->finishUp();

        $bridge = new BridgeContent();

        $customDataFr = [
            'title' => 'FAQ',
            'custom_slug' => 'faq',
            'redirection_page' => 'FAQListingPage',
            'status' => 1,
            'langcode' => 'fr',
        ];

        $existingFr = Custom::query()
            ->where('custom_slug', $customDataFr['custom_slug'])
            ->where('redirection_page', $customDataFr['redirection_page'])
            ->where('langcode', 'fr')
            ->first();

        if ($existingFr instanceof Custom) {
            $customDataFr['uuid'] = $existingFr->uuid;
        }

        $originalUuid = $bridge->contentInsert(
            type: 'custom',
            data: $customDataFr,
            creation: !isset($customDataFr['uuid']),
            fromCli: true
        );
    }
}
