<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class IchbAdsPostings extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        ContentBlueprints::generateContent(contentType: 'postings_categories');
        ContentBlueprints::generateContent(contentType: 'postings');
        $this->finishUp();

        $bridge = new BridgeContent();

        $customDataFr = [
            'title' => 'Petites annonces',
            'custom_slug' => 'ads',
            'redirection_page' => 'AdsListingPage',
            'status' => 1,
            'langcode' => 'fr',
        ];

        $existingFr = Custom::query()
            ->where('custom_slug', $customDataFr['custom_slug'])
            ->where('redirection_page', $customDataFr['redirection_page'])
            ->where('langcode', 'fr')
            ->first();

        if ($existingFr instanceof Custom) {
            $customDataFr['uuid'] = $existingFr->uuid;
        }

        $originalUuid = $bridge->contentInsert(
            type: 'custom',
            data: $customDataFr,
            creation: !isset($customDataFr['uuid']),
            fromCli: true
        );
    }
}
