<?php

use Illuminate\Database\Migrations\Migration;
use Inside\I18n\Models\Translation;
use Inside\Support\Str;

final class FixTranslationsForGroupsTitles extends Migration
{
    public function up(): void
    {
        Translation::query()
            ->where('text', 'like', '%groups.data.0.title%')
            ->whereRaw('text NOT LIKE "%:groups.data.0.title%"')
            ->each(fn (Translation $translation) => $translation->update(['text' => Str::replace('groups.data.0.title', ':groups.data.0.title', $translation->text ?? '')]));

        Translation::query()
            ->where('text', 'like', '%groups.0.title%')
            ->whereRaw('text NOT LIKE "%:groups.0.title%"')
            ->each(fn (Translation $translation) => $translation->update(['text' => Str::replace('groups.0.title', ':groups.data.0.title', $translation->text ?? '')]));

        Translation::query()
            ->where('text', 'like', '%:groups.0.title%')
            ->each(fn (Translation $translation) => $translation->update(['text' => Str::replace(':groups.0.title', ':groups.data.0.title', $translation->text ?? '')]));
    }
}
