<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\I18n\Models\CachedTranslation;
use Inside\I18n\Models\Translation;
use Inside\Support\Str;

final class FixGroupsPostsTranslations extends Migration
{
    public function up(): void
    {
        Translation::query()
            ->where('text', 'like', '%:groups.title%')
            ->each(fn (Translation $translation) => $translation->update(['text' => Str::replace(':groups.title', ':groups.data.0.title', $translation->text)])); // @phpstan-ignore-line

        CachedTranslation::query()
            ->where('text', 'like', '%:groups.title%')
            ->each(fn (CachedTranslation $translation) => $translation->update(['text' => Str::replace(':groups.title', ':groups.data.0.title', $translation->text)])); // @phpstan-ignore-line
    }
}
