<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class RemoveDurationFromTv extends Migration
{
    public function up(): void
    {
        if (
            Schema::hasModel('tv_screens') &&
            Schema::hasField('tv_screens', 'duration')
        ) {
            $bridge = new BridgeContentType();
            $bridge->contentTypeDeleteField(
                'node',
                'tv_screens',
                'duration'
            );
            Artisan::call("models:rebuild");
        }
    }
}
