<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateWidgetBridgePhone extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = ['phone', 'fax', 'mobile'];

        foreach ($fields as $field) {
            $bridge->contentTypeUpdateField('users', $field, [
                'widget' => [
                    'type' => BridgeContentType::INSIDE_PHONE_WIDGET,
                ],
                'searchable' => true
            ]);
        }
    }

    public function down(): void
    {
    }
}
