<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFetchedContentsToContentFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $infos = [
            "news" => [
                "required" => false,
                "weight" => -2,
                "extra" => ['map', 'document_cards']
            ],
            "events" => [
                "required" => true,
                "weight" => 0,
                "extra" => ['map']
            ],
            "spaces_pages" => [
                "required" => false,
                "weight" => -4,
                "extra" => []
            ],
            "pages" => [
                "required" => false,
                "weight" => -4,
                "extra" => []
            ]
        ];

        $types = ["news", "events", "spaces_pages", "pages"];

        foreach ($types as $type) {
            $bridge->contentTypeCreateOrUpdateField(
                $type,
                'content',
                [
                    'name' => 'content',
                    'searchable' => true,
                    'translatable' => false,
                    'search_result_field' => false,
                    'required' => $infos[$type]["required"],
                    'weight' => $infos[$type]["weight"],
                    'title' => [
                        'fr' => 'Contenu',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::SECTION_WIDGET,
                        'settings' => [
                            'title' => 'Paragraphe',
                            'title_plural' => 'Paragraphes',
                            'edit_mode' => 'open',
                            'add_mode' => 'dropdown',
                            'form_display_mode' => 'default',
                            'default_paragraph_type' => '',
                        ],
                        'weight' => 2,
                    ],
                    'type' => BridgeContentType::SECTION_FIELD,
                    'settings' => [
                        'target_type' => array_merge(['text', 'text_with_image', 'file', 'image', 'video', 'slider', 'html', 'accordion', 'call_to_action', 'files', 'fetched_contents'], $infos[$type]["extra"]),
                        'cardinality' => -1,
                    ],
                ],
                $infos[$type]["weight"]
            );
        }
    }

    public function down(): void
    {
    }
}
