<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateFieldsFaxForUsers extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'fax',
            [
                'name' => 'fax',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Fax'
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 1,
                ],
                'settings' => [
                ]

            ],
            1
        );
    }

    public function down(): void
    {
    }
}
