<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddEndDateToDuties extends Migration
{
    use \Inside\Database\Migrations\HasConsole;

    public function up(): void
    {
        $this->write('Création du champ <fg=magenta>end_date</fg=magenta> sur le contenu <fg=cyan>duties</fg=cyan>');

        $bridge = new BridgeContentType();
        $this->writeResult(
            $bridge->contentTypeCreateOrUpdateField(
                'duties',
                'end_date',
                [
                    'name'                => 'end_date',
                    'searchable'          => false,
                    'translatable'        => false,
                    'default'             => null,
                    'search_result_field' => false,
                    'required'            => true,
                    'weight'              => 2,
                    'title'               => [
                        'fr' => 'Date de fin',
                    ],
                    'description'         => [
                        'fr' => '',
                    ],
                    'widget'              => [
                        'type'     => BridgeContentType::TIMESTAMP_WIDGET,
                        'settings' => [],
                        'weight'   => 2,
                    ],
                    'type'                => BridgeContentType::TIMESTAMP_FIELD,
                    'settings'            => [
                        'cardinality' => 1,
                    ],
                ]
            )
        );
    }
}
