<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddIsFeaturedFieldsToForms extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $field = [
            'name' => 'is_featured',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Est mis en avant ?'
            ],
            'description' => [
                'fr' => ''
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 1,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ];

        $bridge->contentTypeCreateOrUpdateField('forms', 'is_featured', $field);
    }
}
