<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'name' => 'duties',
        'title' => [
            'fr' => 'Astreintes',
        ],
    ],
    'fields' => [
        [
            'name' => 'date',
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Jour'
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => $weight++
            ],
            'settings' => [
                'cardinality' => 1
            ],
        ],
    ],
    [
        'name' => 'time',
        'type' => BridgeContentType::TEXT_FIELD,
        'searchable' => false,
        'translatable' => false,
        'search_result_field' => false,
        'required' => true,
        'weight' => $weight,
        'title' => [
            'fr' => 'Heure',
        ],
        'widget' => [
            'type' => BridgeContentType::STRING_WIDGET,
            'settings' => [],
            'weight' => $weight++,
        ],
        'settings' => [
            'cardinality' => 1,
        ],
    ],
    [
        'name' => 'weight',
        'type' => BridgeContentType::INTEGER_FIELD,
        'searchable' => false,
        'translatable' => false,
        'search_result_field' => false,
        'required' => false,
        'weight' => $weight,
        'title' => [
            'fr' => 'Poids',
        ],
        'widget' => [
            'type' => BridgeContentType::NUMBER_WIDGET,
            'settings' => [],
            'weight' => $weight++,
        ],
        'settings' => [
            'cardinality' => 1,
        ],
    ],
];
