<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'cards_links',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Image avec lien',
            'en' => 'Image with link',
            'nl' => 'Afbeelding met link',
            'pt' => 'Imagem com link',
            'es' => 'Imagen con enlace',
            'de' => 'Bild mit Link',
        ],
    ],
    'fields' => [
        [
            'name' => 'link',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Lien',
                'en' => 'Link',
                'nl' => 'Link',
                'pt' => 'Link',
                'es' => 'Enlace',
                'de' => 'Link',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Image',
                'en' => 'Picture',
                'nl' => 'Afbeelding',
                'pt' => 'Foto',
                'es' => 'Imagen',
                'de' => 'Bild',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de exibição',
                'es' => 'Orden de visualización',
                'de' => 'Reihenfolge anzeigen',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes back to 1st',
                'nl' => 'Het laagste getal gaat naar 1e',
                'pt' => 'O número mais baixo volta para o 1º',
                'es' => 'El número más bajo vuelve al 1.º',
                'de' => 'Die niedrigste Zahl geht auf den 1. zurück',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'is_featured',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Mis en avant ?',
                'en' => 'Featured?',
                'nl' => 'Uitgelicht?',
                'pt' => 'Apresentou?',
                'es' => '¿Presentado?',
                'de' => 'Vorgestellt?',
            ],
            'description' => [
                'fr' => 'Si coché, le bloc remontera sous la bannière de la page d’accueil',
                'en' => 'If checked, the block will go back under the banner of the home page',
                'nl' => 'Indien aangevinkt, gaat het blok terug onder de banner van de startpagina',
                'pt' => 'Se marcado, o bloco voltará para baixo do banner da página inicial',
                'es' => 'Si se marca, el bloque volverá debajo del banner de la página de inicio',
                'de' => 'Wenn aktiviert, wird der Block unter dem Banner der Startseite zurückgehen',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
