<?php

return [
    'types' => [
        'news',
        'events',
    ],
    'export' => [
        'contents' => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL') . '/edit/' . class_to_type($model) . '/' . $model->uuid;
                },
            ],
        ],
        'users'    => [
            'headers' => [
                'email'    => 'Mail address',
                'fullname' => 'Full name',
            ],
        ],
        'authentication' => [
            'headers' => [
            ],
        ],
    ],
];
