<?php

namespace Inside\ICHB\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\ICHB\Facades\Duty;

/**
 * Class DutyController
 *
 * @package Inside\ICHB\src\Http\Controllers
 */
class DutyController extends Controller
{
    /**
     *  List duties by days by services
     */
    public function index(Request $request): JsonResponse
    {
        $startDate = $request->get('start_date');
        $endDate   = $request->get('end_date');
        if ($startDate === null || $endDate === null) {
            throw new \InvalidArgumentException('You must set start & end date');
        }

        return response()->json(Duty::getDutiesList($startDate, $endDate));
    }
}
