<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => false
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/ichb-back/resources/assets/img/newsletter/bg.jpg',
        'backgroundColor' => '#ffffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'body',
        'textColor' => '#0C7694'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#032c49',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#1D91D3',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#1D91D3',
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#1D91D3',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/centrehenribecquerel',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/centrebecquerel',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/centre-henri-becquerel',
            ],
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
