<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Custom;

class IchbQuizCustomPage extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $customDataFr = [
            'title' => 'Quiz',
            'custom_slug' => 'quiz',
            'redirection_page' => 'QuizListingPage',
            'status' => 1,
            'langcode' => 'fr',
        ];

        $existingFr = Custom::query()
            ->where('custom_slug', $customDataFr['custom_slug'])
            ->where('redirection_page', $customDataFr['redirection_page'])
            ->where('langcode', 'fr')
            ->first();

        if ($existingFr instanceof Custom) {
            $customDataFr['uuid'] = $existingFr->uuid;
        }

        $originalUuid = $bridge->contentInsert(
            type: 'custom',
            data: $customDataFr,
            creation: !isset($customDataFr['uuid']),
            fromCli: true
        );
    }
}
