<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddSecondPhoneToUsersType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'second_phone',
            [
                'name' => 'second_phone',
                'searchable' => true,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Deuxième numéro de téléphone',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_PHONE_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [],
            ]
        );
    }
}
