<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class RemoveCreateorupdateToNotif extends Migration
{
    public function up(): void
    {
        $notificationType = NotificationType::query()
            ->where('model', 'Inside\Content\Models\Contents\News')
            ->where('via', 'web')
            ->where('action', 'createOrUpdate')
            ->where('type', 'global')
            ->where('condition', 'is_featured:1|status:1')->first();

        if ($notificationType instanceof NotificationType) {
            $notificationType->action = 'create';
            $notificationType->language = 0;
            $notificationType->save();
        }
    }

    public function down(): void
    {
    }
}
