<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\DynamicClass;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;

class ReworkUsersFields extends Migration
{
    use HasConsole;

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $bridge = new BridgeContentType();
        $this->write('Création type <fg=magenta>organisational_services</fg=magenta>');
        $this->writeResult(
            $bridge->contentTypeUpdateOrCreate(
                'organisational_services',
                [
                    'translatable'      => false,
                    'searchable'        => true,
                    'global_searchable' => false,
                    'aliasable'         => false,
                    'permissible'       => true,
                    'categorizable'     => true,
                    'name'              => 'organisational_services',
                    'title'             => [
                        'fr' => 'Services',
                    ],
                ],
                []
            )
        );

        $this->write('Champ <fg=cyan>location</fg=cyan> n\'est plus requis');
        $bridge->updateFieldOptions('users', 'location', ['required' => false]);
        $this->writeResult(true);

        $this->write('Champ <fg=cyan>phone</fg=cyan> n\'est plus requis');
        $bridge->updateFieldOptions('users', 'phone', ['required' => false]);
        $this->writeResult(true);

        $this->write('Champ <fg=cyan>services</fg=cyan> est filtrable');
        $bridge->updateFieldOptions('users', 'services', ['searchable_filter' => true]);
        $this->writeResult(true);

        $this->write('Champ <fg=cyan>functions</fg=cyan> est filtrable');
        $bridge->updateFieldOptions('users', 'functions', ['searchable_filter' => true]);
        $this->writeResult(true);

        // Services
        $this->write('Ajout d\'un champ <fg=cyan>code</fg=cyan> aux <fg=magenta>organisational_services</fg=magenta>');
        $this->writeResult(
            $bridge->contentTypeCreateOrUpdateField(
                'organisational_services',
                'code',
                [
                    'name'                => 'code',
                    'title'               => [
                        'fr' => 'Code',
                    ],
                    'description'         => [
                        'fr' => '',
                    ],
                    'cardinality'         => 1,
                    'translatable'        => false,
                    'required'            => true,
                    'default'             => 'UNKOWN',
                    'searchable'          => false,
                    'front_field_config'  => '{}',
                    'non_exportable'      => true,
                    'categorizable'       => false,
                    'searchable_filter'   => true,
                    'search_result_field' => false,
                    'type'                => BridgeContentType::TEXT_FIELD,
                    'settings'            => [
                        'cardinality' => 1,
                    ],
                    'widget'              => [
                        'type'     => BridgeContentType::TEXT_WIDGET,
                        'settings' => [],
                    ],
                ]
            )
        );

        $this->write(
            'Ajout d\'un champ <fg=cyan>service parent</fg=cyan> aux <fg=magenta>organisational_services</fg=magenta>'
        );
        $this->writeResult(
            $bridge->contentTypeCreateOrUpdateField(
                'organisational_services',
                'organisational_services',
                [
                    'name'                => 'organisational_services',
                    'title'               => [
                        'fr' => 'Service parent',
                    ],
                    'description'         => [
                        'fr' => '',
                    ],
                    'translatable'        => false,
                    'required'            => false,
                    'default'             => [],
                    'searchable'          => false,
                    'front_field_config'  => '{}',
                    'non_exportable'      => true,
                    'categorizable'       => false,
                    'searchable_filter'   => true,
                    'search_result_field' => false,
                    'type'                => BridgeContentType::REFERENCE_FIELD,
                    'settings'            => [
                        'cardinality' => 1,
                        'target_type' => ['organisational_services'],
                    ],
                    'widget'              => [
                        'type'     => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                    ],
                ]
            )
        );

        // Utilisateurs
        $this->write('Ajout d\'un champ <fg=cyan>cn</fg=cyan> aux <fg=magenta>utilisateurs</fg=magenta>');
        $this->writeResult(
            $bridge->contentTypeCreateOrUpdateField(
                'users',
                'cn',
                [
                    'name'                => 'cn',
                    'title'               => [
                        'fr' => 'CN',
                    ],
                    'description'         => [
                        'fr' => '',
                    ],
                    'translatable'        => false,
                    'required'            => false,
                    'default'             => '',
                    'searchable'          => false,
                    'front_field_config'  => '{}',
                    'non_exportable'      => true,
                    'categorizable'       => false,
                    'searchable_filter'   => true,
                    'search_result_field' => false,
                    'type'                => BridgeContentType::TEXT_FIELD,
                    'settings'            => [
                        'cardinality' => 1,
                    ],
                    'widget'              => [
                        'type'     => BridgeContentType::TEXT_WIDGET,
                        'settings' => [],
                    ],
                ]
            )
        );

        $this->write('Ajout d\'un champ <fg=cyan>dn</fg=cyan> aux <fg=magenta>utilisateurs</fg=magenta>');
        $this->writeResult(
            $bridge->contentTypeCreateOrUpdateField(
                'users',
                'dn',
                [
                    'name'                => 'dn',
                    'title'               => [
                        'fr' => 'DN',
                    ],
                    'description'         => [
                        'fr' => '',
                    ],
                    'translatable'        => false,
                    'required'            => false,
                    'default'             => '',
                    'searchable'          => false,
                    'front_field_config'  => '{}',
                    'non_exportable'      => true,
                    'categorizable'       => false,
                    'searchable_filter'   => true,
                    'search_result_field' => false,
                    'type'                => BridgeContentType::TEXT_FIELD,
                    'settings'            => [
                        'cardinality' => 1,
                    ],
                    'widget'              => [
                        'type'     => BridgeContentType::TEXT_WIDGET,
                        'settings' => [],
                        'hidden'   => true,
                    ],
                ]
            )
        );

        $this->write('Ajout d\'un champ <fg=cyan>other_services</fg=cyan> aux <fg=magenta>utilisateurs</fg=magenta>');
        $this->writeResult(
            $bridge->contentTypeCreateOrUpdateField(
                'users',
                'other_services',
                [
                    'name'                => 'other_services',
                    'title'               => [
                        'fr' => 'Autres services',
                    ],
                    'description'         => [
                        'fr' => '',
                    ],
                    'translatable'        => false,
                    'required'            => false,
                    'default'             => [],
                    'searchable'          => false,
                    'front_field_config'  => '{}',
                    'non_exportable'      => true,
                    'categorizable'       => false,
                    'searchable_filter'   => true,
                    'search_result_field' => false,
                    'type'                => BridgeContentType::REFERENCE_FIELD,
                    'settings'            => [
                        'cardinality' => -1,
                        'target_type' => ['services'],
                    ],
                    'widget'              => [
                        'type'     => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                    ],
                ]
            )
        );

        $this->write('Ajout d\'un champ <fg=cyan>organisational_services</fg=cyan> aux <fg=magenta>utilisateurs</fg=magenta>');
        $this->writeResult(
            $bridge->contentTypeCreateOrUpdateField(
                'users',
                'organisational_services',
                [
                    'name'                => 'organisational_services',
                    'title'               => [
                        'fr' => 'Services',
                    ],
                    'description'         => [
                        'fr' => '',
                    ],
                    'translatable'        => false,
                    'required'            => false,
                    'default'             => [],
                    'searchable'          => false,
                    'front_field_config'  => '{}',
                    'non_exportable'      => true,
                    'categorizable'       => false,
                    'searchable_filter'   => true,
                    'search_result_field' => false,
                    'type'                => BridgeContentType::REFERENCE_FIELD,
                    'settings'            => [
                        'cardinality' => -1,
                        'target_type' => ['organisational_services'],
                    ],
                    'widget'              => [
                        'type'     => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                    ],
                ]
            )
        );

        $this->write('Ajout d\'un champ <fg=cyan>is_from_ldap</fg=cyan> aux <fg=magenta>utilisateurs</fg=magenta>');
        $this->writeResult(
            $bridge->contentTypeCreateOrUpdateField(
                'users',
                'is_from_ldap',
                [
                    'name'                => 'is_from_ldap',
                    'title'               => [
                        'fr' => 'LDAP',
                    ],
                    'description'         => [
                        'fr' => '',
                    ],
                    'translatable'        => false,
                    'required'            => false,
                    'default'             => false,
                    'searchable'          => false,
                    'front_field_config'  => '{}',
                    'non_exportable'      => true,
                    'categorizable'       => false,
                    'searchable_filter'   => true,
                    'search_result_field' => false,
                    'type'                => BridgeContentType::BOOLEAN_FIELD,
                    'settings'            => [
                        'cardinality' => 1,
                    ],
                    'widget'              => [
                        'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                        'settings' => [],
                    ],
                ]
            )
        );

        DynamicClass::enableRebuildAutoLoad();
        Artisan::call('models:rebuild');
    }
}
