<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\User\Models\User;

class AddJoinEventNotification extends Migration
{
    public function up(): void
    {
        $notificationTypes = [];

        /** @var NotificationType[] $notificationTypes */
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => ReactionSubscribedEvent::class,
                'model'     => 'Inside\Content\Models\Contents\Events',
                'action'    => 'join',
                'condition' => 'author:CURRENT_USER',
                'multiple'  => true,
                'language'  => true,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.create.join.event.title',
                    'description' => 'notifications.create.join.event.description',
                    'icon'        => 'join',
                    'text'        => 'notifications.create.join.event.text',
                    'fields'      => [
                        'title',
                    ],
                ],
            ]
        );

        foreach ($notificationTypes as $notificationType) {
            User::each(fn ($user) => NotificationSubscriber::firstOrCreate([
                'user_uuid' => $user->uuid,
                'notification_type_id' => $notificationType->id,
            ]));
        }
    }
}
