<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class UsersMigration extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $fields = [
            'shortcuts_menus',
            'function'
        ];

        foreach ($fields as $field) {
            $this->bridge->contentTypeDeleteField('user', 'user', $field);
        }

        $this->migrateContent('users_titles');
        $this->migrateContent('functions');
        $this->migrateContent('services');
        $this->migrateContent('users');

        $this->getConsole()->writeln('<info>Création de contenus par défaut</info>');

        $bridge = new BridgeContent();

        $users_titles = ['Dr', 'Pr'];
        foreach ($users_titles as $usersTitle) {
            $bridge->contentInsert(
                'users_titles',
                [
                    'bundle' => 'users_titles',
                    'type' => 'node',
                    'title' => $usersTitle,
                ]
            );
        }

        $this->getConsole()->writeln('<info>'.count($users_titles).' contenus créés.</info>');
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
