<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class ContentsTypesMigration extends Migration
{
    use CreateContentTypes;

    /**
     * @var string[]
     */
    private $contentTypes = [
        'custom',
        'duties',
        'duties_pages',
        'duties_services',
        'folders',
        'documents',
        'events_categories',
        'events',
        'info_flashes',
        'news_categories',
        'jobs_contracts',
        'jobs',
        'news',
        'pages',
        'rcp_folders',
        'rcp_documents',
        'rcp_services',
        'rcp_spaces',
        'self_menus',
        'spaces',
        'spaces_categories',
        'spaces_pages',
        'tools',
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__);

        foreach ($this->contentTypes as $contentType) {
            $this->migrateContent($contentType);
        }

        $this->finishUp();
    }

    public function down(): void
    {
        $this->bridge = new BridgeContentType();

        foreach ($this->contentTypes as $contentType) {
            $this->bridge->contentTypeDelete($contentType);
        }
    }
}
