<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'name' => 'users',
        'title' => [
            'fr' => 'Utilisateurs',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'editable' => true,
            'title' => [
                'fr' => 'Image',
            ],
        ],
        [
            'name' => 'firstname',
            'editable' => false,
            'title' => [
                'fr' => 'Prénom',
            ],
        ],
        [
            'name' => 'lastname',
            'editable' => false,
            'title' => [
                'fr' => 'Nom',
            ],
        ],
        [
            'name' => 'phone',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Téléphone du service',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'mobile',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Téléphone perso',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'location',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Localisation',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'users_titles',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Titre',
            ],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['users_titles'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'services',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Service',
            ],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['services'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'secretary',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Secrétaire',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'wight' => 5,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'functions',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'editable' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Fonction',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['functions'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'tools',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'editable' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Mes accès rapides',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['tools'],
                'cardinality' => -1,
            ],
        ],
    ],
];
