<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'name' => 'spaces_pages',
        'title' => [
            'fr' => 'Pages RH',
        ],
    ],
    'fields' => [
        [
            'name' => 'content',
            'type' => BridgeContentType::SECTION_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['text', 'text_with_image', 'image', 'file', 'video', 'html', 'accordion', 'call_to_action', 'files', 'slider'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'spaces_categories',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Catégories RH',
            ],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['spaces_categories'],
                'cardinality' => -1,
            ],
        ],
    ],
];
