<?php

use Illuminate\Support\Facades\Log;

return [
    'schedule' => [
        'log_status' => function ($scheduler) {
            $scheduler->call(
                function () {
                    Log::info('Scheduler is running.');
                }
            )->hourly();
        },
        'user_import' => function ($scheduler) {
            $scheduler->command('inside:user:import ldap --disable-not-imported')->daily()->at('2:00');
        },
    ],
];
