import get from 'lodash.get'
import ShortcutsUsersE2E from '@inside-users/tests-e2e/class/ShortcutsUsersE2E'

export default class _ShortcutsUsersE2E extends ShortcutsUsersE2E {
  constructor(props) {
    super(props)
  }

  goToEditShortcuts() {
    it('Go to edit shortcuts', () => {
      cy.intercept('/api/v1/content/users').as('users')
      cy.intercept(`/api/v1/content/${this.moduleConfig.shortcuts.content}`).as(
        'content'
      )

      cy.cleanOverlays(1000)

      cy.get('.title a').click()
      cy.wait(['@users', '@content']).spread((users, contents) => {
        this.contents = contents.response.body.data
      })
    })
  }

  checkNoShortcuts() {
    it('Check no shortcuts on homepage', () => {
      cy.cleanOverlays(1000)

      cy.intercept('/api/v1/content/users').as('users')
      cy.visit('/')
      cy.wait('@users').then(users => {
        const shortcuts = get(
          users,
          `response.body.data.0.${this.moduleConfig.shortcuts.content}.data`,
          []
        )

        expect(shortcuts.length).eq(0)
      })

      cy.get('.empty-listing').should('be.visible')

      cy.wait(5000)
    })
  }

  checkShortcutsBehaviour() {
    cy.get(
      '.homepage-shortcuts-listing-container .shortcut-link-item-container'
    ).each((item, index) => {
      cy.get(item)
        .find('.title')
        .invoke('text')
        .should('contains', this.shortcuts[index].title)
    })
  }
}
