import { http } from '@inside-library/helpers/Http'
import get from 'lodash.get'
import alphaRedirections from '../pages/projects/alpha/redirections.js'
import iaRedirections from '../pages/projects/ia/redirections.js'
import xpsRedirections from '../pages/projects/xps/redirections.js'
import customRedirections from '../pages/projects/custom/redirections.js'

const olympicParent = async fields => {
  const uuid = fields.olympics

  try {
    const { data } = await http.get('content/olympics', {
      filters: { 'uuid:eq': uuid },
      fields: ['slug']
    })

    const slug = get(data, [0, 'slug', 0])

    return {
      name: 'OlympicPage',
      params: { slug }
    }
  } catch (err) {
    return '/'
  }
}

export default {
  newsCategories: {
    add: ({ data }) => ({
      name: 'NewsCategoryPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'NewsListingPage' })
  },
  articlesBcaAssistance: {
    add: ({ data }) => ({
      name: 'BcaAssistanceArticlePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'BcaAssistanceListPage' })
  },
  newsletters: {
    add: ({ data }) => ({
      name: 'NewsletterPage',
      params: { slug: data.slug[0] }
    })
  },
  newslettersHr: {
    add: ({ data }) => ({
      name: 'NewsletterHrPage',
      params: { slug: data.slug[0] }
    })
  },
  olympics: {
    add: ({ data }) => ({
      name: 'OlympicPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ path: '/' })
  },
  olympicsSemifinal: {
    add: ({ data }) => ({
      name: 'OlympicSemifinalPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ path: '/' })
  },
  olympicsFinal: {
    add: ({ data }) => ({
      name: 'OlympicFinalPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ path: '/' })
  },
  sequences: {
    add: async ({ fields }) => olympicParent(fields),
    delete: () => ({ path: '/' })
  },
  sequencesStatus: {
    add: async ({ fields }) => olympicParent(fields),
    delete: () => ({ path: '/' })
  },
  rhPages: {
    add: () => ({
      name: 'HrPage'
    }),
    delete: () => ({ path: '/' })
  },
  jobExchanges: {
    add: () => ({
      name: 'HrPage'
    }),
    delete: () => ({
      name: 'HrPage'
    })
  },
  blocks: {
    add: () => ({
      name: 'HrPage'
    }),
    delete: () => ({ name: 'HrPage' })
  },
  rhFolders: {
    add: ({ data }) => ({
      name: 'GedHrPage',
      query: {
        folder: data.uuid
      }
    }),
    delete: () => ({
      name: 'GedHrPage'
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  rhDocuments: {
    add: ({ fields }) => ({
      name: 'GedHrPage',
      query: {
        folder: fields.rh_folders[0]
      }
    }),
    delete: () => ({
      name: 'GedHrPage'
    }),
    globalSearch: ({ data, vm }) => ({
      action: () =>
        vm.triggerModal(
          'doc-ged',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
    })
  },
  foldersHr: {
    add: ({ data }) => ({
      name: 'OldGedHrPage',
      query: { folder: data.uuid }
    }),
    delete: () => ({
      name: 'OldGedHrPage'
    })
  },
  documentsHr: {
    fields: [{ folders_hr: ['uuid'] }],
    add: ({ data }) => ({
      name: 'OldGedHrPage',
      query: { folder: data.folders_hr.data[0].uuid }
    }),
    delete: () => ({
      name: 'OldGedHrPage'
    })
  },
  dsmLink: {
    fields: [{ folders_hr: ['uuid'] }],
    add: ({ data }) => ({
      name: 'OldGedHrPage',
      query: { folder: data.folders_hr.data[0].uuid }
    }),
    delete: () => ({
      name: 'OldGedHrPage'
    })
  },
  directVideos: {
    add: () => ({
      name: 'DirectVideoPage'
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  tools: {
    add: () => ({
      name: 'ToolsPage'
    }),
    delete: () => ({
      name: 'ToolsPage'
    })
  },
  toolsCategories: {
    extends: 'tools'
  },
  ...alphaRedirections,
  ...iaRedirections,
  ...xpsRedirections,
  ...customRedirections
}
