import { http } from '@inside-library/helpers/Http'

export default {
  xpsProjects: {
    add: () => ({
      name: 'ProjectXpsPage'
    })
  },
  xpsProjectsPhases: {
    add: ({ data }) => ({
      name: 'ProjectXpsPhasePage',
      params: { phase: data.slug[0] }
    })
  },
  xpsProjectsVideos: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/xps_projects_videos', {
          fields: [{ xps_projects_phases: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectXpsVideosPage',
          params: { phase: res.data[0].xps_projects_phases.data[0].slug[0] }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  xpsProjectsDocuments: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/xps_projects_documents', {
          fields: [
            { xps_projects_phases: ['slug'] },
            { xps_projects_folders: ['uuid'] }
          ],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectXpsGedPage',
          params: { phase: res.data[0].xps_projects_phases.data[0].slug[0] },
          query: {
            folder: res.data[0].xps_projects_folders.uuid
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  xpsProjectsFolders: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/xps_projects_folders', {
          fields: ['uuid', { xps_projects_phases: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectXpsGedPage',
          params: { phase: res.data[0].xps_projects_phases.data[0].slug[0] },
          query: {
            folder: res.data[0].uuid
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  xpsProjectsNews: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/xps_projects_news', {
          fields: ['uuid', 'slug', { xps_projects_phases: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectXpsNewsPage',
          params: {
            phase: res.data[0].xps_projects_phases.data[0].slug[0],
            slug: res.data[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  }
}
