import { withFetch } from 'inside-collection/hocs'
import {
  fetchIaProject,
  fetchIaProjectForSubPage
} from '../../../fetch/projects.js'

import ProjectIaSinglePage from './ProjectIaSinglePage.vue'
import ProjectIaGedPage from './ProjectIaGedPage.vue'
import ProjectIaGalleryPage from './ProjectIaGalleryPage.vue'

export default [
  {
    name: 'ProjectIaListingPage',
    path: '/projets/ia',
    component: () => import('./ProjectIaListingPage.vue')
  },
  {
    name: 'ProjectIaSinglePage',
    path: '/projets/ia/:project',
    component: withFetch(ProjectIaSinglePage, {
      size: 'xxl'
    })(fetchIaProject)
  },
  {
    name: 'ProjectIaGedPage',
    path: '/projets/ia/:project/bibliotheque',
    component: withFetch(ProjectIaGedPage, {
      size: 'xxl'
    })(fetchIaProjectForSubPage)
  },
  {
    name: 'ProjectIaGalleryPage',
    path: '/projets/ia/:project/galerie',
    component: withFetch(ProjectIaGalleryPage, {
      size: 'xxl'
    })(fetchIaProjectForSubPage)
  }
]
