import { http } from '@inside-library/helpers/Http'

export default {
  customProjects: {
    add: ({ data }) => ({
      name: 'ProjectCustomPage',
      params: { project: data.slug[0] }
    }),
    delete: () => ({ name: 'ProjectListPage' }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  customProjectsDocuments: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/custom_projects_documents', {
          fields: [
            { ia_projects: ['slug'] },
            { ia_projects_folders: ['uuid'] }
          ],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectCustomGedPage',
          params: { project: res.data[0].custom_projects.slug[0] },
          query: {
            folder: res.data[0].custom_projects_folders.uuid
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  customProjectsFolders: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/custom_projects_folders', {
          fields: ['uuid', { ia_projects: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectCustomGedPage',
          params: { project: res.data[0].custom_projects.slug[0] },
          query: {
            folder: res.data[0].uuid
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  customProjectsVideos: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/custom_projects_videos', {
          fields: [{ custom_projects: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectCustomGalleryPage',
          params: { project: res.data[0].custom_projects.slug[0] }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  customProjectsNews: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/custom_projects_news', {
          fields: [{ custom_projects: ['slug'] }, 'slug'],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectCustomNewsPage',
          params: {
            project: res.data[0].custom_projects.slug[0],
            slug: res.data[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: () => ({ name: 'ProjectListPage' })
  },
  customProjectsEvents: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/custom_projects_events', {
          fields: [{ custom_projects: ['slug'] }, 'slug'],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectCustomEventPage',
          params: {
            project: res.data[0].custom_projects.slug[0],
            slug: res.data[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: () => ({ name: 'ProjectListPage' })
  }
}
