import { withFetch } from 'inside-collection/hocs'
import {
  fetchAlphaProject,
  fetchAlphaProjectForBanner
} from '../../../fetch/projects.js'

import ProjectAlphaSinglePage from './ProjectAlphaSinglePage.vue'
import ProjectAlphaNewsListingPage from './ProjectAlphaNewsListingPage.vue'
import ProjectAlphaNewsPage from './ProjectAlphaNewsPage.vue'
import ProjectAlphaEventsListingPage from './ProjectAlphaEventsListingPage.vue'
import ProjectAlphaEventsPage from './ProjectAlphaEventsPage.vue'

export default [
  {
    name: 'ProjectAlphaListingPage',
    path: '/projets/alpha',
    component: () => import('./ProjectAlphaListingPage.vue')
  },
  {
    name: 'ProjectAlphaSinglePage',
    path: '/projets/alpha/:project',
    component: withFetch(ProjectAlphaSinglePage, {
      size: 'xxl'
    })(fetchAlphaProject)
  },
  {
    name: 'ProjectAlphaNewsListingPage',
    path: '/projets/alpha/:project/les-chantiers',
    component: withFetch(ProjectAlphaNewsListingPage, {
      size: 'xxl'
    })(fetchAlphaProjectForBanner)
  },
  {
    name: 'ProjectAlphaNewsPage',
    path: '/projets/alpha/:project/les-chantiers/:slug',
    component: withFetch(ProjectAlphaNewsPage, {
      size: 'xxl'
    })(fetchAlphaProjectForBanner)
  },
  {
    name: 'ProjectAlphaEventsListingPage',
    path: '/projets/alpha/:project/les-etapes',
    component: withFetch(ProjectAlphaEventsListingPage, {
      size: 'xxl'
    })(fetchAlphaProjectForBanner)
  },
  {
    name: 'ProjectAlphaEventsPage',
    path: '/projets/alpha/:project/les-etapes/:slug',
    component: withFetch(ProjectAlphaEventsPage, {
      size: 'xxl'
    })(fetchAlphaProjectForBanner)
  }
]
