import FullNews from '@inside-news/components/lib/Full'
import MinimalNews from '@inside-news/components/lib/Minimal'
import FullEvent from '@inside-events/components/lib/Full'
import MinimalEvent from '@inside-events/components/lib/Minimal'
import BcaAssistanceCard from './components/bca-assistance/BcaAssistanceCard.vue'

export default {
  globals: {
    translationsEndpoint: 'lang.json/',
    icons: {
      bookmark: 'rate',
      bookmarkFill: 'rate-fill'
    },
    notificationRedirectionsContentTypes: ['news'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'News',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-ged': {
    useV2: true
  },
  'inside-news': {
    templates: {
      fullContent: {
        mainFields: () => [
          'content',
          'image',
          'chapo',
          {
            news_categories: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          }
        ],
        relatedFields: () => [
          'image',
          'chapo',
          {
            news_categories: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          }
        ]
      }
    }
  },
  'inside-auth': {
    e2e: {
      useSSO: true
    }
  },
  'inside-events': {
    subscriptionEnabled: true
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    e2e: {
      userNav: ['profile', 'bookmarks', 'shortcuts', 'preferences', 'logout']
    }
  },
  'inside-tests': {
    e2e: {
      useCleanOverlays: true
    }
  },
  'inside-searches': {
    mainSearchSort: true
  },
  'inside-layouts': {
    templates: {
      fullContent: {
        articlesBcaAssistance: {
          mainComponent: FullNews,
          relatedComponent: BcaAssistanceCard
        },
        projectsNews: {
          mainComponent: FullNews,
          relatedComponent: MinimalNews
        },
        projectsEvents: {
          mainComponent: FullEvent,
          relatedComponent: MinimalEvent
        },
        xpsProjectsNews: {
          mainComponent: FullNews,
          relatedComponent: MinimalNews
        },
        customProjectsNews: {
          mainComponent: FullNews,
          relatedComponent: MinimalNews
        },
        customProjectsEvents: {
          mainComponent: FullEvent,
          relatedComponent: MinimalEvent
        }
      }
    }
  }
}
