import Vue from 'vue'

import insideConfig from './inside.config.js'
import redirections from './redirections'
import routes from './router'

export default {
  name: 'inside-customs',
  displays: {},
  modals: {
    'alpha-modal': Vue.component('alpha-modal', () =>
      import('./components/modal/AlphaModal')
    ),
    'concerned-modal': Vue.component('concerned-modal', () =>
      import('./components/modal/ConcernedModal')
    ),
    'direct-modal': Vue.component('direct-modal', () =>
      import('./components/modal/DirectModal')
    ),
    'flash-info-modal': Vue.component('flash-info-modal', () =>
      import('./components/modal/FlashInfoModal')
    ),
    'project-modal': Vue.component('project-modal', () =>
      import('./components/modal/ProjectModal')
    ),
    'olympics-modal': Vue.component('olympics-modal', () =>
      import('./components/modal/OlympicModal')
    ),
    'rh-modal': Vue.component('rh-modal', () =>
      import('./components/modal/RhModal')
    ),
    'activities-modal': Vue.component('activities-modal', () =>
      import('./components/modal/ActivitiesModal')
    )
  },
  paragraphs: {
    'gallery-paragraph': Vue.component('gallery-paragraph', () =>
      import('./components/olympics/final-page/GalleryParagraph')
    )
  },
  config: {
    tabs: {
      homepage: ['general']
    }
  },
  insideConfig,
  routes,
  redirections
}
