import { http } from '@inside-library/helpers/Http'

const fetchAlphaProject = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      filters: {
        'slug:eq': $route.params.project
      },
      fields: [
        'uuid',
        'title',
        'logo',
        'admin',
        'slug',
        'content_type',
        'color',
        'key_number_1',
        'key_number_2',
        'key_number_3',
        'key_numbers_background',
        'key_numbers_separator',
        'file_1',
        'file_title_1',
        'file_2',
        'file_title_2',
        'file_3',
        'file_title_3',
        'file_4',
        'file_title_4',
        'file_5',
        'file_title_5',
        'client_advisers',
        'experts',
        'support_functions',
        'video',
        { projects_status: ['title', 'color'] }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchAlphaProjectForBanner = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      filters: {
        'slug:eq': $route.params.project
      },
      fields: [
        'uuid',
        'title',
        'logo',
        'admin',
        'slug',
        'content_type',
        'color',
        { projects_status: ['title', 'color'] }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchIaProject = async ({ $route }) => {
  try {
    const { data } = await http.get('content/ia_projects', {
      filters: {
        'slug:eq': $route.params.project
      },
      fields: [
        'uuid',
        'title',
        'admin',
        'slug',
        'image',
        'content_type',
        'subtitle',
        'about',
        'content',
        'categories',
        { referents: ['firstname', 'lastname', 'image', 'uuid'] },
        { ia_projects_targets: ['title'] },
        { ia_projects_status: ['title', 'color'] }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchIaProjectForSubPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/ia_projects', {
      filters: {
        'slug:eq': $route.params.project
      },
      fields: ['uuid', 'title', 'slug']
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchXPSProject = async () => {
  try {
    const { data } = await http.get('content/xps_projects', {
      fields: [
        'uuid',
        'title',
        'slug',
        'admin',
        'banner',
        'content_type',
        'popin',
        'content',
        'xps_project_subtitle',
        'first_advantage',
        'second_advantage',
        'third_advantage'
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchProjectPhase = async ({ $route }) => {
  try {
    const { data } = await http.get('content/xps_projects_phases', {
      filters: {
        'slug:eq': $route.params.phase
      },
      fields: [
        'title',
        'image',
        'slug',
        'published_at',
        'content_type',
        'start_date',
        'end_date',
        'admin',
        'perimeters',
        'uuid',
        'banner',
        'content',
        {
          xps_projects_status: ['title', 'color', 'uuid']
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchProjectPhaseForSubPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/xps_projects_phases', {
      filters: {
        'slug:eq': $route.params.phase
      },
      fields: ['title', 'slug', 'uuid']
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchProjectCustom = async ({ $route }) => {
  try {
    const { data } = await http.get('content/custom_projects', {
      filters: {
        'slug:eq': $route.params.phase
      },
      fields: [
        'uuid',
        'chapo',
        'status',
        'pid',
        'image',
        'admin',
        'title',
        'content_type',
        'slug',
        'published_at',
        'content',
        'about',
        'background',
        'key_number_1',
        'key_number_2',
        'key_number_3',
        'key_numbers_background',
        'key_numbers_separator',
        { custom_projects_status: ['title', 'color'] },
        { referents: { fields: ['lastname', 'firstname', 'image', 'uuid'] } }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchProjectCustomForSubPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/custom_projects', {
      filters: {
        'slug:eq': $route.params.project
      },
      fields: [
        'title',
        'slug',
        'uuid',
        'background',
        { custom_projects_status: ['title', 'color'] }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export {
  fetchAlphaProject,
  fetchAlphaProjectForBanner,
  fetchIaProject,
  fetchIaProjectForSubPage,
  fetchXPSProject,
  fetchProjectPhase,
  fetchProjectPhaseForSubPage,
  fetchProjectCustom,
  fetchProjectCustomForSubPage
}
