import { http } from '@inside-library/helpers/Http'

const fields = (rh = false) => [
  'uuid',
  'title',
  'slug',
  'content_type',
  'admin',
  'published_at',
  'body',
  {
    news: [
      'title',
      'uuid',
      'slug',
      'content_type',
      'chapo',
      'image',
      'published_at',
      {
        news_categories: {
          fields: ['title', 'uuid', 'slug'],
          filters: rh ? { 'title:eq': 'Ressources Humaines' } : {}
        }
      }
    ]
  },
  {
    documents: [
      'title',
      'uuid',
      'slug',
      'content_type',
      'file',
      'published_at',
      {
        folders: ['title', 'uuid', 'slug']
      }
    ]
  },
  ...(rh
    ? [
        {
          documents_hr: [
            'title',
            'uuid',
            'slug',
            'content_type',
            'file',
            'published_at',
            {
              folders_hr: ['title', 'uuid', 'slug']
            }
          ]
        }
      ]
    : []),
  {
    events: [
      'title',
      'uuid',
      'slug',
      'content_type',
      'date',
      'published_at',
      {
        events_categories: ['title', 'uuid', 'slug']
      }
    ]
  }
]

const fetchNewsletter = async ({ $route }) => {
  try {
    const { data } = await http.get('content/newsletters', {
      filters: {
        'slug:eq': $route.params.slug
      },
      fields: fields()
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchHrNewsletter = async ({ $route }) => {
  try {
    const { data } = await http.get('content/newsletters_hr', {
      filters: {
        'slug:eq': $route.params.slug
      },
      fields: fields(true)
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchNewsletter, fetchHrNewsletter }
