import { http } from '@inside-library/helpers/Http'

const fetchDirect = async ({ $route }) => {
  try {
    const { data } = await http.get('content/direct_pages', {
      filters: {
        'status:eq': 1
      },
      fields: [
        'title',
        'direct_introduction',
        'link',
        'next_show',
        'slug',
        'content_type',
        'button_text',
        'content_type',
        'uuid',
        'admin'
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchDirect }
