import OlympicPage from '../pages/olympics/OlympicPage.vue'
import OlympicSemifinalPage from '../pages/olympics/OlympicSemifinalPage.vue'
import OlympicFinalPage from '../pages/olympics/OlympicFinalPage.vue'
import {
  fetchOlympic,
  fetchOlympicSemifinal,
  fetchOlympicFinal
} from '../fetch/olympics'

import TeamPage from '../pages/TeamPage'
import { fetchFullGroup } from '@inside-teams/fetch'

import NewsletterPage from '../pages/newsletters/NewsletterPage.vue'
import NewsletterHrPage from '../pages/newsletters/NewsletterHrPage.vue'
import { fetchNewsletter, fetchHrNewsletter } from '../fetch/newsletters.js'

import DirectVideoPage from '../pages/DirectVideoPage.vue'
import { fetchDirect } from '../fetch/direct.js'

import alphaProjectRoutes from '../pages/projects/alpha/router'
import customProjectRoutes from '../pages/projects/custom/router'
import iaProjectRoutes from '../pages/projects/ia/router'
import xpsProjectRoutes from '../pages/projects/xps/router'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { ROUTE_NAMES as EVENTS_ROUTES } from '@inside-events/constants'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/news/NewsListingPage.vue'),
    meta: { disabled: false }
  },
  {
    name: 'NewsCategoryPage',
    path: '/categorie/:slug',
    component: () => import('../pages/news/NewsCategoryPage.vue')
  },
  {
    name: 'NewsPage',
    component: () => import('../pages/news/NewsPage.vue'),
    meta: { disabled: false }
  },
  {
    name: EVENTS_ROUTES.calendar,
    meta: { disabled: false }
  },
  {
    name: EVENTS_ROUTES.page,
    meta: { disabled: false },
    props: {
      contentOptions: {
        printEnabled: true
      }
    }
  },
  {
    name: EVENTS_ROUTES.subscription,
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'BcaAssistanceListPage',
    path: '/bca-assistance',
    component: () => import('../pages/bca-assistance/BcaAssistanceListPage.vue')
  },
  {
    name: 'BcaAssistanceArticlePage',
    path: '/bca-assistance/:slug',
    component: () =>
      import('../pages/bca-assistance/BcaAssistanceArticlePage.vue')
  },
  {
    name: 'OlympicPage',
    path: '/olympiades/:slug',
    component: withFetch(OlympicPage, { size: 'xxl' })(fetchOlympic)
  },
  {
    name: 'OlympicSemifinalPage',
    path: '/olympiades-demi-finale/:slug',
    component: withFetch(OlympicSemifinalPage, { size: 'xxl' })(
      fetchOlympicSemifinal
    )
  },
  {
    name: 'OlympicFinalPage',
    path: '/olympiades-finale/:slug',
    component: withFetch(OlympicFinalPage, { size: 'xxl' })(fetchOlympicFinal)
  },
  {
    name: 'HrPage',
    component: () => import('../pages/hr/HrPage.vue'),
    path: '/ressources-humaines'
  },
  {
    name: 'GedHrPage',
    component: () => import('../pages/hr/GedHrPage.vue'),
    path: '/ressources-humaines/bibliotheque'
  },
  {
    name: 'TeamPage',
    component: withFetch(TeamPage, { size: 'xxl' })(fetchFullGroup)
  },
  {
    name: 'DirectoryPage',
    path: '/who-s-who',
    component: () => import('../pages/DirectoryPage.vue'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    props: { cardOverlayEnabled: false, defaultSort: 'published_at' },
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    component: () => import('../pages/ToolsPage.vue')
  },
  {
    name: 'NewsletterPage',
    path: '/newsletter/:slug',
    component: withFetch(NewsletterPage, { size: 'xxl' })(fetchNewsletter)
  },
  {
    name: 'NewsletterHrPage',
    path: '/newsletter-rh/:slug',
    component: withFetch(NewsletterHrPage, { size: 'xxl' })(fetchHrNewsletter)
  },
  {
    name: 'DirectVideoPage',
    path: '/le-direct',
    component: withFetch(DirectVideoPage, { size: 'xxl' })(fetchDirect)
  },
  {
    name: 'ProjectListPage',
    path: '/les-projets',
    component: () => import('../pages/projects/ProjectsListPage.vue')
  },
  ...alphaProjectRoutes,
  ...customProjectRoutes,
  ...iaProjectRoutes,
  ...xpsProjectRoutes,
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { permissionKey: 'advanced-settings', display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { permissionKey: 'advanced-settings', display: true }
  }
]
