import { withFetch } from 'inside-collection/hocs'
import {
  fetchXPSProject,
  fetchProjectPhase,
  fetchProjectPhaseForSubPage
} from '../../../fetch/projects.js'

import ProjectXpsPage from './ProjectXpsPage.vue'
import ProjectXpsPhasePage from './ProjectXpsPhasePage.vue'
import ProjectXpsPhaseNewsListingPage from './ProjectXpsPhaseNewsListingPage.vue'
import ProjectXpsNewsPage from './ProjectXpsNewsPage.vue'
import ProjectXpsVideosPage from './ProjectXpsVideosPage.vue'
import ProjectXpsGedPage from './ProjectXpsGedPage.vue'

export default [
  {
    name: 'ProjectXpsPage',
    path: '/projets/xps',
    component: withFetch(ProjectXpsPage, {
      size: 'xxl'
    })(fetchXPSProject)
  },
  {
    name: 'ProjectXpsPhasePage',
    path: '/projets/xps/:phase',
    component: withFetch(ProjectXpsPhasePage, {
      size: 'xxl'
    })(fetchProjectPhase)
  },
  {
    name: 'ProjectXpsPhaseNewsListingPage',
    path: '/projets/xps/:phase/chantiers',
    component: withFetch(ProjectXpsPhaseNewsListingPage, {
      size: 'xxl'
    })(fetchProjectPhaseForSubPage)
  },
  {
    name: 'ProjectXpsNewsPage',
    path: '/projets/xps/:phase/chantiers/:slug',
    component: withFetch(ProjectXpsNewsPage, {
      size: 'xxl'
    })(fetchProjectPhaseForSubPage)
  },
  {
    name: 'ProjectXpsVideosPage',
    path: '/projets/xps/:phase/videos',
    component: withFetch(ProjectXpsVideosPage, {
      size: 'xxl'
    })(fetchProjectPhaseForSubPage)
  },
  {
    name: 'ProjectXpsGedPage',
    path: '/projets/xps/:phase/bibliotheque',
    component: withFetch(ProjectXpsGedPage, {
      size: 'xxl'
    })(fetchProjectPhaseForSubPage)
  }
]
