import { http } from '@inside-library/helpers/Http'

export default {
  iaProjects: {
    add: ({ data }) => ({
      name: 'ProjectIaSinglePage',
      params: { project: data.slug[0] }
    }),
    delete: () => ({ name: 'ProjectAlphaListingPage' }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  iaProjectsDocuments: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/ia_projects_documents', {
          fields: [
            { ia_projects: ['slug'] },
            { ia_projects_folders: ['uuid'] }
          ],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectIaGedPage',
          params: { project: res.data[0].ia_projects.slug[0] },
          query: {
            folder: res.data[0].ia_projects_folders.uuid
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  iaProjectsFolders: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/ia_projects_folders', {
          fields: ['uuid', { ia_projects: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectIaGedPage',
          params: { project: res.data[0].ia_projects.slug[0] },
          query: {
            folder: res.data[0].uuid
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  iaProjectsImages: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/ia_projects_images', {
          fields: [{ ia_projects: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectIaGalleryPage',
          params: { project: res.data[0].ia_projects.slug[0] }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  }
}
