import { withFetch } from 'inside-collection/hocs'
import {
  fetchProjectCustom,
  fetchProjectCustomForSubPage
} from '../../../fetch/projects.js'

import ProjectCustomPage from './ProjectCustomPage.vue'
import ProjectCustomGedPage from './ProjectCustomGedPage.vue'
import ProjectCustomEventsListingPage from './ProjectCustomEventsListingPage.vue'
import ProjectCustomEventPage from './ProjectCustomEventPage.vue'
import ProjectCustomNewsListingPage from './ProjectCustomNewsListingPage.vue'
import ProjectCustomNewsPage from './ProjectCustomNewsPage.vue'
import ProjectCustomGalleryPage from './ProjectCustomGalleryPage.vue'

export default [
  {
    name: 'ProjectCustomPage',
    path: '/projets/specifiques/:project',
    component: withFetch(ProjectCustomPage, {
      size: 'xxl'
    })(fetchProjectCustom)
  },
  {
    name: 'ProjectCustomGedPage',
    path: '/projets/specifiques/:project/bibliotheque',
    component: withFetch(ProjectCustomGedPage, {
      size: 'xxl'
    })(fetchProjectCustomForSubPage)
  },
  {
    name: 'ProjectCustomEventsListingPage',
    path: '/projets/specifiques/:project/les-etapes',
    component: withFetch(ProjectCustomEventsListingPage, {
      size: 'xxl'
    })(fetchProjectCustomForSubPage)
  },
  {
    name: 'ProjectCustomEventPage',
    path: '/projets/specifiques/:project/les-etapes/:slug',
    component: withFetch(ProjectCustomEventPage, {
      size: 'xxl'
    })(fetchProjectCustomForSubPage)
  },
  {
    name: 'ProjectCustomNewsListingPage',
    path: '/projets/specifiques/:project/les-chantiers',
    component: withFetch(ProjectCustomNewsListingPage, {
      size: 'xxl'
    })(fetchProjectCustomForSubPage)
  },
  {
    name: 'ProjectCustomNewsPage',
    path: '/projets/specifiques/:project/les-chantiers/:slug',
    component: withFetch(ProjectCustomNewsPage, {
      size: 'xxl'
    })(fetchProjectCustomForSubPage)
  },
  {
    name: 'ProjectCustomGalleryPage',
    path: '/projets/specifiques/:project/galerie',
    component: withFetch(ProjectCustomGalleryPage, {
      size: 'xxl'
    })(fetchProjectCustomForSubPage)
  }
]
