import { http } from '@inside-library/helpers/Http'

export default {
  projects: {
    add: ({ data }) => ({
      name: 'ProjectAlphaSinglePage',
      params: { project: data.slug[0] }
    }),
    delete: () => ({ name: 'ProjectAlphaListingPage' }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  projectsNews: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/projects_news', {
          fields: [{ projects: ['slug'] }, 'slug'],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectAlphaNewsPage',
          params: {
            project: res.data[0].projects.data[0].slug[0],
            slug: res.data[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: () => ({ name: 'ProjectAlphaListingPage' })
  },
  projectsEvents: {
    add: async ({ data }) => {
      try {
        const res = await http.get('content/projects_events', {
          fields: [{ projects: ['slug'] }, 'slug'],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'ProjectAlphaEventsPage',
          params: {
            project: res.data[0].projects.data[0].slug[0],
            slug: res.data[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: () => ({ name: 'ProjectAlphaListingPage' })
  },
  projectsEventsCategories: {
    add: () => ({ name: 'ProjectAlphaListingPage' }),
    delete: () => ({ name: 'ProjectAlphaListingPage' })
  }
}
