export default {
  globals: {
    translationsEndpoint: 'lang.json/',
    icons: {
      bookmark: 'rate',
      bookmarkFill: 'rate-fill'
    },
    notificationRedirectionsContentTypes: ['news'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'News',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-ged': {
    useV2: true
  },
  'inside-news': {
    templates: {
      fullContent: {
        mainFields: () => [
          'content',
          'image',
          'chapo',
          {
            news_categories: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          }
        ],
        relatedFields: () => [
          'image',
          'chapo',
          {
            news_categories: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          }
        ]
      }
    }
  },
  'inside-auth': {
    e2e: {
      useSSO: true
    }
  },
  'inside-events': {
    subscriptionEnabled: true
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  },
  'inside-tests': {
    e2e: {
      useCleanOverlays: true
    }
  },
  'inside-searches': {
    mainSearchSort: true
  },
  'inside-layouts': {
    templates: {
      fullContent: {
        articlesBcaAssistance: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('./components/bca-assistance/BcaAssistanceCard.vue')
        },
        projectsNews: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        },
        projectsEvents: {
          mainComponent: () => import('@inside-events/components/lib/Full'),
          relatedComponent: () => import('@inside-events/components/lib/Minimal')
        },
        xpsProjectsNews: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        },
        customProjectsNews: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        },
        customProjectsEvents: {
          mainComponent: () => import('@inside-events/components/lib/Full'),
          relatedComponent: () => import('@inside-events/components/lib/Minimal')
        }
      }
    }
  }
}
