import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import AlphaModal from '../components/modal/AlphaModal'
import ConcernedModal from '../components/modal/ConcernedModal'
import DirectModal from '../components/modal/DirectModal'
import FlashInfoModal from '../components/modal/FlashInfoModal'
import ProjectModal from '../components/modal/ProjectModal'
import OlympicModal from '../components/modal/OlympicModal'
import RhModal from '../components/modal/RhModal'
import ActivitiesModal from '../components/modal/ActivitiesModal'
import GalleryParagraph from '../components/olympics/final-page/GalleryParagraph'
import CloseFlashInfoCustoms from '../components/modal/sub-components/CloseFlashInfoCustoms'
import CloseDirectCustoms from '../components/modal/sub-components/CloseDirectCustoms'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('alpha-modal', AlphaModal)
    app.component('concerned-modal', ConcernedModal)
    app.component('direct-modal', DirectModal)
    app.component('flash-info-modal', FlashInfoModal)
    app.component('project-modal', ProjectModal)
    app.component('olympics-modal', OlympicModal)
    app.component('rh-modal', RhModal)
    app.component('activities-modal', ActivitiesModal)
    app.component('gallery-paragraph', GalleryParagraph)
    app.component('close-flash-info-customs', CloseFlashInfoCustoms)
    app.component('close-direct-customs', CloseDirectCustoms)
  })
}
