import { http } from '@inside-library/helpers/Http'

const fetchActivityStats = async () => {
  try {
    const { data } = await http.get('content/activities_block', {
      fields: [
        'uuid',
        'title',
        'content_type',
        'admin',
        'image',
        'content',
        {
          activity_stats: {
            fields: ['uuid', 'title', 'image', 'stat'],
            filters: {
              'status:eq': 1,
              sort: 'published_at:desc',
              limit: 3
            }
          }
        }
      ],
      filters: {
        limit: 1,
        'status:eq': 1,
        sort: 'published_at:desc'
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchActivityStats }
