<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\IBCA\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('ibca/newsletter/{type}/{uuid}', ['uses' => 'IBCAController@view']);

        $router->get('popin', ['uses' => 'PopinController@popin']);
        $router->post('reaction/popin', ['uses' => 'PopinController@reaction']);

        $router->get('direct/popin', ['uses' => 'PopinController@directPopin']);
        $router->post('direct/reaction/popin', ['uses' => 'PopinController@reactToPopin']);
    }
);
